IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ANALISA_MARGEM_EST_PROD_PRECO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ANALISA_MARGEM_EST_PROD_PRECO]
GO
GO

--exec P_ANALISA_MARGEM_EST_PROD_PRECO
CREATE PROCEDURE [dbo].[P_ANALISA_MARGEM_EST_PROD_PRECO] (@CD_USU INT) WITH ENCRYPTION AS  
BEGIN TRY
begin

	SET NOCOUNT ON;
    DECLARE @DT_REF DATE
    SET @DT_REF=GETDATE()
	DECLARE @STS_ALT_PRECO INT
	SET @STS_ALT_PRECO=1
	DECLARE @TIPO_CUSTO_ANALISE_EMPRESA INT
    DECLARE @ANALISA_CUSTO_PRODUTO_PRECIFICACAO INT
	
	
	SET @ANALISA_CUSTO_PRODUTO_PRECIFICACAO = ISNULL(
                                (
                                    SELECT VALOR
                                    FROM PRC_EMP_CONFIG
                                    WHERE CD_CHAVE = 'ANALISA_CUSTO_PRODUTO_PRECIFICACAO'
                                ), 0);
								
	IF(@ANALISA_CUSTO_PRODUTO_PRECIFICACAO = 0)
		RETURN;
	
	CREATE TABLE #RsProdPrecoVigente(CD_EMP INT,
									 CD_GRUPO INT,
									 CD_PROD INT,
									 VLR_TABELA MONEY,
									 VLR_TABELA_VIGENTE MONEY,
									 VLR_OFERTA_VIGENTE MONEY,
									 CD_ALT_PRECO INT,
									 CD_ALT_PRECO_ANTERIOR INT,
									 TP_NIVEL_PERC INT,
									 PERC_MARGEM MONEY,
									 DS_PERC_MARGEM VARCHAR(400),
									 TP_CUSTO INT,
									 DS_TP_CUSTO VARCHAR(400),
									 VLR_CUSTO MONEY)	
										 
	CREATE TABLE #RsGrupoPrecos (CD_EMP INT, 
								 CD_ALT_PRECO  INT,
								 CD_GRUPO INT)

	INSERT INTO #RsGrupoPrecos
	SELECT  
		 
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP,
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_ALT_PRECO,
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO

	FROM            
		EST_PROD_PRECO_ALT 
		
		INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
		EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
		EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
		
		INNER JOIN EST_PROD_PRECO_ALT_PRC_FILIAL ON 
		EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP AND 
		EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_ALT_PRECO 
				
		INNER JOIN  EST_PRECIFICACAO_GRP_PRECO_FILIAL ON 
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP AND 
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_FILIAL = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_FILIAL
		 
		INNER JOIN  EST_PRECIFICACAO_GRP_PRECO ON 
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP = EST_PRECIFICACAO_GRP_PRECO.CD_EMP AND 
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO = EST_PRECIFICACAO_GRP_PRECO.CD_GRUPO
		
		INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD

		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD

		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD

		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD

	WHERE

		EST_PROD_PRECO_ALT.APLICADO IN (0,2)
		AND EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
		AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
		AND EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD IS NULL	
		AND EST_PROD_PRECO_ALT.CD_EMP=1
		AND EST_PRECIFICACAO_GRP_PRECO.TIPO_GRUPO=0
		AND ISNULL(EST_PROD_PRECO_ALT.DT_AGENDADA,'20000101') <= @DT_REF
		AND EST_PROD_PRECO_ALT.CD_USU = @CD_USU
		AND EST_PROD_PRECO_ALT.TP_ALT_PRECO=0

	GROUP BY
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP,
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_ALT_PRECO,
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO

		-- SELECT * FROM #RsGrupoPrecos

--=============================================================================================
	--Gravando o valor tabela vigente 
	INSERT INTO #RsProdPrecoVigente
	(CD_EMP, CD_GRUPO, CD_PROD, VLR_TABELA, VLR_TABELA_VIGENTE, VLR_OFERTA_VIGENTE, CD_ALT_PRECO, CD_ALT_PRECO_ANTERIOR)
	SELECT
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP,
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO,
		EST_PROD_PRECO.CD_PROD,
		EST_PROD_PRECO_ALT_CPL.VLR_TABELA,
		ROUND(ISNULL(AVG(EST_PROD_PRECO.VLR_TABELA),0),2) AS VLR_TABELA_VIGENTE,
		ROUND(ISNULL(AVG(EST_PROD_PRECO.VLR_OFERTA),0),2) AS VLR_OFERTA_VIGENTE,
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO,
		MAX(ISNULL(EST_PROD_PRECO.CD_ALT_PRECO,0)) AS CD_ALT_PRECO_ANTERIOR
	FROM
		EST_PROD_PRECO INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL ON
		EST_PROD_PRECO.CD_EMP = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP AND
		EST_PROD_PRECO.CD_FILIAL = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_FILIAL
		INNER JOIN #RsGrupoPrecos GRP ON
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP = GRP.CD_EMP AND
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO = GRP.CD_GRUPO
		INNER JOIN EST_PROD_PRECO_ALT_CPL ON
		GRP.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND
		GRP.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO AND
		EST_PROD_PRECO.CD_PROD = EST_PROD_PRECO_ALT_CPL.CD_PROD
	GROUP BY
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP,
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO,
		EST_PROD_PRECO.CD_PROD,
		EST_PROD_PRECO_ALT_CPL.VLR_TABELA,
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO

		-- SELECT * FROM #RsProdPrecoVigente

--=============================================================================================

	UPDATE 
		 #RsProdPrecoVigente
	SET
		 #RsProdPrecoVigente.TP_NIVEL_PERC = 0,
		 #RsProdPrecoVigente.PERC_MARGEM = 0,
		 #RsProdPrecoVigente.DS_PERC_MARGEM = '',
		 #RsProdPrecoVigente.TP_CUSTO = 0,
		 #RsProdPrecoVigente.DS_TP_CUSTO = '',
		 #RsProdPrecoVigente.VLR_CUSTO = 0,
		 #RsProdPrecoVigente.VLR_TABELA = DBO.F_ARREDONDAR_PRECO_VENDA_TABELA(#RsProdPrecoVigente.VLR_TABELA)
	FROM
		 #RsProdPrecoVigente INNER JOIN #RsGrupoPrecos GRP ON
		 #RsProdPrecoVigente.CD_EMP = GRP.CD_EMP AND
		 #RsProdPrecoVigente.CD_ALT_PRECO = GRP.CD_ALT_PRECO	
		INNER JOIN EST_PROD ON
		 #RsProdPrecoVigente.CD_EMP = EST_PROD.CD_EMP AND
		 #RsProdPrecoVigente.CD_PROD = EST_PROD.CD_PROD 
	WHERE
		EST_PROD.CTR_PMC=0

	-- SELECT * FROM #RsProdPrecoVigente
							 
	--=============================================================================================	
		
    SET @TIPO_CUSTO_ANALISE_EMPRESA = ISNULL(
                                (
                                    SELECT VALOR
                                    FROM PRC_EMP_CONFIG
                                    WHERE CD_CHAVE = 'TIPO_CUSTO_ANALISE_EMPRESA'
                                ), 0);
	
	/*
		0 - Ultimo custo
		1 - Custo medio
		2 - Custo gerencial
	*/	

	--Buscando dados de meta de margem do produto
	UPDATE
		#RsProdPrecoVigente
	SET   
		#RsProdPrecoVigente.TP_NIVEL_PERC = ISNULL(B.TP_NIVEL_PERC,0),
		#RsProdPrecoVigente.PERC_MARGEM = ISNULL(B.PERC_MARGEM,0),
		#RsProdPrecoVigente.DS_PERC_MARGEM = ISNULL(B.DS_PERC_MARGEM,'META MARGEM NAO DEFINIDA'),
		#RsProdPrecoVigente.VLR_CUSTO = CASE WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 0 THEN --Ultimo custo
												ISNULL(EST_PROD.VLR_CUSTO_GRP,0)
											WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 1 THEN --Custo medio
												ISNULL(EST_PROD.VLR_CUSTO_MD_GRP,0)
											WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 2 THEN --Custo gerencial
												ISNULL(EST_PROD.VLR_CUSTO_GER_GRP,0)
											END,
		#RsProdPrecoVigente.TP_CUSTO = @TIPO_CUSTO_ANALISE_EMPRESA,
		#RsProdPrecoVigente.DS_TP_CUSTO=CASE WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 0 THEN --Ultimo custo
												'PARAMETRO ULTIMO CUSTO'
											WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 1 THEN --Custo medio
												'PARAMETRO CUSTO MEDIO'
											WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 2 THEN --Custo gerencial
												'PARAMETRO CUSTO GERENCIAL'
											END
	FROM            
		EST_PROD_PRECO_ALT
		 
		INNER JOIN #RsProdPrecoVigente ON 
		EST_PROD_PRECO_ALT.CD_EMP = #RsProdPrecoVigente.CD_EMP AND 
		EST_PROD_PRECO_ALT.CD_ALT_PRECO = #RsProdPrecoVigente.CD_ALT_PRECO 

		INNER JOIN #RsGrupoPrecos GRP ON
		EST_PROD_PRECO_ALT.CD_EMP = GRP.CD_EMP AND
		EST_PROD_PRECO_ALT.CD_ALT_PRECO = GRP.CD_ALT_PRECO

		INNER JOIN EST_PROD ON
		#RsProdPrecoVigente.CD_EMP = EST_PROD.CD_EMP AND
		#RsProdPrecoVigente.CD_PROD = EST_PROD.CD_PROD

		INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
		#RsProdPrecoVigente.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
		#RsProdPrecoVigente.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
		#RsProdPrecoVigente.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD

		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
		#RsProdPrecoVigente.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
		#RsProdPrecoVigente.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
		#RsProdPrecoVigente.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD

		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
		#RsProdPrecoVigente.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
		#RsProdPrecoVigente.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
		#RsProdPrecoVigente.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD

		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
		#RsProdPrecoVigente.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
		#RsProdPrecoVigente.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
		#RsProdPrecoVigente.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD

		OUTER APPLY UFD_EST_PROD_PRECIFICACAO_META_MARGEM(#RsProdPrecoVigente.CD_EMP, GRP.CD_GRUPO, #RsProdPrecoVigente.CD_PROD) B

	WHERE
		EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
		AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
		AND  EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD IS NULL

	-- SELECT * FROM #RsProdPrecoVigente

	
	--bloqueandp o produto que nao possuir margem definida 
	--ou margem menor que a definida no parametro 
	INSERT INTO EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE
		(CD_EMP,
		CD_ALT_PRECO,
		CD_PROD,
		DT_CAD,
		DS_BLOQUEIO)
		SELECT
			#RsProdPrecoVigente.CD_EMP,
			#RsProdPrecoVigente.CD_ALT_PRECO,
			#RsProdPrecoVigente.CD_PROD,
			GETDATE(),
			CASE WHEN #RsProdPrecoVigente.VLR_CUSTO = 0 THEN
				CASE WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 0 THEN --Ultimo custo
					'ULTIMO CUSTO ZERADO'
				WHEN @TIPO_CUSTO_ANALISE_EMPRESA= 1 THEN --Custo medio
					'CUSTO MEDIO ZERADO'
				WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 2 THEN --Custo gerencial
					'CUSTO GERENCIAL ZERADO'
				END			
			ELSE
				'ERRO DE META DE MARGEM FORA DO ESPERADO'
			END 
		FROM            
			EST_PROD_PRECO_ALT 
			INNER JOIN #RsProdPrecoVigente ON 
			EST_PROD_PRECO_ALT.CD_EMP = #RsProdPrecoVigente.CD_EMP AND 
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = #RsProdPrecoVigente.CD_ALT_PRECO 
			INNER JOIN #RsGrupoPrecos GRP ON
			EST_PROD_PRECO_ALT.CD_EMP = GRP.CD_EMP AND
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = GRP.CD_ALT_PRECO
			INNER JOIN EST_PROD ON
			#RsProdPrecoVigente.CD_EMP = EST_PROD.CD_EMP AND
			#RsProdPrecoVigente.CD_PROD = EST_PROD.CD_PROD
			INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
			#RsProdPrecoVigente.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
			#RsProdPrecoVigente.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
			#RsProdPrecoVigente.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
			#RsProdPrecoVigente.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
			#RsProdPrecoVigente.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
			#RsProdPrecoVigente.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
			#RsProdPrecoVigente.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
			#RsProdPrecoVigente.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
			#RsProdPrecoVigente.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
			#RsProdPrecoVigente.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
			#RsProdPrecoVigente.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
			#RsProdPrecoVigente.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD
		WHERE
			EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
			AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
			AND EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD IS NULL		
			AND (#RsProdPrecoVigente.VLR_CUSTO = 0 
				OR ((#RsProdPrecoVigente.PERC_MARGEM / 100) * #RsProdPrecoVigente.VLR_CUSTO) + #RsProdPrecoVigente.VLR_CUSTO > #RsProdPrecoVigente.VLR_TABELA)

	DROP TABLE #RsGrupoPrecos;
	DROP TABLE #RsProdPrecoVigente;
end
END TRY
BEGIN CATCH
	declare @erro varchar (500) = ERROR_MESSAGE();
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
			RAISERROR(@erro, 16, 1);
END CATCH	